IF EXISTS ( SELECT * FROM sysobjects WHERE  id = object_id(N'CPJ_Cbtes_ReqCompra_GenerarOrdenDeCompra') and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
	DROP PROCEDURE dbo.CPJ_Cbtes_ReqCompra_GenerarOrdenDeCompra 
END
GO

CREATE PROCEDURE [dbo].[CPJ_Cbtes_ReqCompra_GenerarOrdenDeCompra] @pJson VARCHAR(8000)
AS 
SET NOCOUNT ON 

/* Variables */
DECLARE @pId_Trans							INT
DECLARE @pModoDebug							TINYINT
DECLARE @pId_Usuario						INT
DECLARE @Last_Id_Trans						INT
DECLARE @Req_Compra_Comprobante_Nro			INT 
DECLARE @Req_Compra_Fecha					DATE
DECLARE @Req_Compra_Id_Tipo_Cbte			VARCHAR(15)
DECLARE @Cbte_Tipo_Prox_Comprobante_Nro		INT
DECLARE @Cbte_Tipo_Id_Estado_Cbte			INT

SET @pModoDebug				= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'ModoDebug')), 0)
SET @pId_Usuario			= ISNULL(CONVERT(INT, dbo.CF_JSON_VALUE(@pJson,'Id_Usuario')), 0)
SET @pId_Trans				= ISNULL(CONVERT(INT, dbo.CF_JSON_VALUE(@pJson,'Id_Trans')), 0)

BEGIN TRY
	BEGIN TRANSACTION

	-- Lanzo error
	IF (dbo.CF_xParam('T_Cbte_Ord_Comp') = '') RAISERROR ('Sin código asignado a la orden de compra', 16,  1 ) 


	-- Creo la transacción
	SET @Last_Id_Trans = ISNULL((SELECT MAX(Id_Trans) FROM Transacciones), 0) + 1
	INSERT INTO Transacciones (Id_Trans, Fecha_mov, Id_Usuario) VALUES	(@Last_Id_Trans, GETDATE(), @pId_Usuario)

	-- Copio la info del Requerimiento de Compra (Comprobante)
	SELECT * INTO #Cbtes FROM Cbtes WHERE Id_Trans = @pId_Trans
	SELECT @Req_Compra_Comprobante_Nro = Comprobante_Nro, @Req_Compra_Fecha = Fecha, @Req_Compra_Id_Tipo_Cbte = Id_Tipo_Cbte 
	FROM Cbtes WHERE Id_Trans = @pId_Trans
	-- Copio la info del tipo de Comprobante original
	SELECT * INTO #Cbtes_Tipos FROM Cbtes_Tipos WHERE Id_Tipo_Cbte = @Req_Compra_Id_Tipo_Cbte
	-- Actualizo el próximo número de comprobante
	UPDATE Cbtes_Tipos SET Prox_Nro = Prox_Nro + 1 WHERE Id_Tipo_Cbte = @Req_Compra_Id_Tipo_Cbte

	SELECT @Cbte_Tipo_Prox_Comprobante_Nro = Prox_Nro, @Cbte_Tipo_Id_Estado_Cbte = Id_Estado_Cbte FROM Cbtes_Tipos WHERE Id_Tipo_Cbte = dbo.CF_xParam('T_Cbte_Ord_Comp')
	
	IF(@pModoDebug = 1)
	BEGIN
		PRINT '@Last_Id_Trans: ' + CONVERT(VARCHAR(10), @Last_Id_Trans)
		PRINT '@Req_Compra_Comprobante_Nro: ' + CONVERT(VARCHAR(20), @Req_Compra_Comprobante_Nro)
		PRINT '@Req_Compra_Fecha: ' + CONVERT(VARCHAR(20), @Req_Compra_Fecha) 
		PRINT '@Req_Compra_Id_Tipo_Cbte: ' + CONVERT(VARCHAR(15), @Req_Compra_Id_Tipo_Cbte)
		PRINT '@Cbte_Tipo_Prox_Comprobante_Nro: ' + CONVERT(VARCHAR(20), @Cbte_Tipo_Prox_Comprobante_Nro)
		PRINT '@Cbte_Tipo_Id_Estado_Cbte: ' + CONVERT(VARCHAR(15), @Cbte_Tipo_Id_Estado_Cbte)
	END

	UPDATE 
		#Cbtes 
	SET 
		Id_Trans = @Last_Id_Trans, 
		Id_Tipo_Cbte = dbo.CF_xParam('T_Cbte_Ord_Comp'), 
		Cbte_Nro_Externo = @Req_Compra_Comprobante_Nro, 
		Periodo_Iva = @Req_Compra_Fecha, 
		Periodo = @Req_Compra_Fecha,
		Comprobante_Nro = @Cbte_Tipo_Prox_Comprobante_Nro,
		Id_Estado_Cbte = 1
	WHERE 
		Id_Trans = @pId_Trans
		

	IF (dbo.CF_xParam('Ord_Compra_Aprobac') = 1)
	BEGIN
		UPDATE #Cbtes SET Id_Tipo_Cbte = dbo.CF_xParam('Est_OC_Req_Aprob') WHERE Id_Trans = @Last_Id_Trans 
	END 
	/* ELSE 
	BEGIN 
		IF (@Cbte_Tipo_Id_Estado_Cbte = 0)
		BEGIN 
			UPDATE #Cbtes SET Id_Estado_Cbte = 1 WHERE Id_Trans = @Last_Id_Trans 
		END 
		ELSE
		BEGIN
			UPDATE #Cbtes SET Id_Estado_Cbte = @Cbte_Tipo_Id_Estado_Cbte
		END
	END */
	
	IF (@pModoDebug = 1 ) SELECT * FROM #Cbtes

	-- Creo el comprobante
	INSERT INTO Cbtes SELECT * FROM #Cbtes

	DECLARE @cursor_item INT
	DECLARE @cursor_Porcentaje1 FLOAT
	DECLARE @cursor_Id_Producto VARCHAR(14)

	-- Itero por los items del comprobante original para agregarlos al comprobante creado
	DECLARE cursorCbtesItems CURSOR LOCAL FOR SELECT Item, Id_Producto FROM Cbtes_Items WHERE Id_Trans = @pId_Trans AND Item <> 0
	OPEN cursorCbtesItems
	FETCH NEXT FROM cursorCbtesItems INTO @cursor_item, @cursor_Id_Producto 
	WHILE @@FETCH_STATUS = 0
	BEGIN
		-- copio el item en una tabla temporal
		SELECT * INTO #Cbtes_Items FROM Cbtes_Items WHERE Id_Trans = @pId_Trans AND Item = @cursor_item

		-- Busco el porcentaje
		SET @cursor_Porcentaje1 = ISNULL((SELECT pti.Porc1 FROM Productos p LEFT JOIN Productos_TasaIva pti ON p.Id_Iva = pti.Id_Iva WHERE p.Id_Producto = @cursor_Id_Producto), 0)

		-- Piso las variables del item
		UPDATE #Cbtes_Items SET Id_Trans = @Last_Id_Trans, Id_Estado_Cbte = dbo.CF_xParam('Est_OC_Req_Aprob') WHERE Item = @cursor_item 
		-- Hago el insert del item en la DB
		INSERT INTO Cbtes_Items SELECT * FROM #Cbtes_Items

		-- Limpio la tabla para el próximo registro
		DROP TABLE #Cbtes_Items
	FETCH NEXT FROM cursorCbtesItems INTO @cursor_item, @cursor_Id_Producto 
	END
	CLOSE cursorCbtesItems


	-- Incremento el proximo numero del tipo de comprobante si es autoincremental
	IF  ISNULL((SELECT CASE WHEN Tipo_Numeracion = 'AUT' THEN 1 ELSE 0 END FROM Cbtes_Tipos WHERE Id_Tipo_Cbte = dbo.CF_xParam('T_Cbte_Ord_Comp')), 0) = 1
	BEGIN
		UPDATE Cbtes_Tipos SET Prox_Nro = Prox_Nro + 1 WHERE Id_Tipo_Cbte = dbo.CF_xParam('T_Cbte_Ord_Comp')
	END

	COMMIT TRANSACTION

	DECLARE @rtaMsjStored			VARCHAR(4000)
	SET @rtaMsjStored =	'{' + dbo.CF_Json_ParsearVariable('Id_Trans', @Last_Id_Trans, 'INT') + '}'

	IF OBJECT_ID('tempdb..#Cbtes') IS NOT NULL DROP TABLE #Cbtes
	IF OBJECT_ID('tempdb..#Cbtes_Items') IS NOT NULL DROP TABLE #Cbtes_Items
	IF OBJECT_ID('tempdb..#Cbtes_Tipos') IS NOT NULL DROP TABLE #Cbtes_Tipos

	SELECT	 0				AS ErrorNumber 
			,0				AS ErrorSeverity  
			,0				AS ErrorState 
			,0				AS ErrorProcedure  
			,0				AS ErrorLine		
			,@rtaMsjStored	AS ErrorMessage
	RETURN 0

END TRY  
BEGIN CATCH  

	IF @@TRANCOUNT > 0
        ROLLBACK TRANSACTION;

	IF OBJECT_ID('tempdb..#Cbtes') IS NOT NULL DROP TABLE #Cbtes
	IF OBJECT_ID('tempdb..#Cbtes_Items') IS NOT NULL DROP TABLE #Cbtes_Items
	IF OBJECT_ID('tempdb..#Cbtes_Tipos') IS NOT NULL DROP TABLE #Cbtes_Tipos

	EXECUTE usp_GetErrorInfo

	RETURN 9999
END CATCH





-- EXEC CPJ_Cbtes_ReqCompra_GenerarOrdenDeCompra '{"Id_Trans":"9597336","Id_Usuario":-1}'